package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.EmpresaAuditora;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0479s00DaoImpl generated by UDA, 23-Jan-2017 10:12:45.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class EmpresaAuditoraDaoImpl implements EmpresaAuditoraDao {

	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT = "SELECT t1.CODEMPAUD_079 CODEMPAUD079, t1.DESEMPAUD_EU_079 DESEMPAUDEU079, t1.DESEMPAUD_ES_079 DESEMPAUDES079, t1.FECBAJ_079 FECBAJ079 FROM AB0479S00 t1 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<EmpresaAuditora> rwMap = new RowMapper<EmpresaAuditora>() {
		public EmpresaAuditora mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EmpresaAuditora(resultSet.getString("CODEMPAUD079"),
					resultSet.getString("DESEMPAUDEU079"),
					resultSet.getString("DESEMPAUDES079"),
					resultSet.getDate("FECBAJ079"));
		}
	};

	private RowMapper<EmpresaAuditora> rwMapPK = new RowMapper<EmpresaAuditora>() {
		public EmpresaAuditora mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EmpresaAuditora(resultSet.getString("CODEMPAUD079"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0479s00 table.
	 * 
	 *  ab0479s00
	 *            Ab0479s00
	 *  Ab0479s00
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 * @return the empresa auditora
	 */
	public EmpresaAuditora add(EmpresaAuditora ab0479s00) {
		Long empresaAuditoraPK = Secuencias.EMPRESA_AUDITORA
				.getNextLong(this.jdbcTemplate);
		if (empresaAuditoraPK != null) {
			ab0479s00.setCodempaud079(empresaAuditoraPK.toString());
		}

		String query = "INSERT INTO AB0479S00 (CODEMPAUD_079, DESEMPAUD_EU_079, DESEMPAUD_ES_079, FECBAJ_079) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, ab0479s00.getCodempaud079(),
				ab0479s00.getDesempaudEu079(), ab0479s00.getDesempaudEs079(),
				ab0479s00.getFecbaj079());
		return ab0479s00;
	}

	/**
	 * Updates a single row in the Ab0479s00 table.
	 * 
	 *  ab0479s00
	 *            Ab0479s00
	 *  Ab0479s00
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 * @return the empresa auditora
	 */
	public EmpresaAuditora update(EmpresaAuditora ab0479s00) {
		String query = "UPDATE AB0479S00 SET DESEMPAUD_EU_079=?, DESEMPAUD_ES_079=?, FECBAJ_079=? WHERE CODEMPAUD_079=?";
		this.jdbcTemplate.update(query, ab0479s00.getDesempaudEu079(),
				ab0479s00.getDesempaudEs079(), ab0479s00.getFecbaj079(),
				ab0479s00.getCodempaud079());
		return ab0479s00;
	}

	/**
	 * Finds a single row in the Ab0479s00 table.
	 * 
	 *  ab0479s00
	 *            Ab0479s00
	 *  Ab0479s00
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 * @return the empresa auditora
	 */
	@Transactional(readOnly = true)
	public EmpresaAuditora find(EmpresaAuditora ab0479s00) {
		StringBuilder query = new StringBuilder(
				EmpresaAuditoraDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.CODEMPAUD_079 = ?");

		List<EmpresaAuditora> ab0479s00List = this.jdbcTemplate.query(
				query.toString(), this.rwMap, ab0479s00.getCodempaud079());
		return (EmpresaAuditora) DataAccessUtils.uniqueResult(ab0479s00List);
	}

	/**
	 * Removes a single row in the Ab0479s00 table.
	 * 
	 *  ab0479s00            Ab0479s00
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 */
	public void remove(EmpresaAuditora ab0479s00) {
		String query = "DELETE FROM AB0479S00 WHERE CODEMPAUD_079=?";
		this.jdbcTemplate.update(query, ab0479s00.getCodempaud079());
	}

	/**
	 * Finds a list of rows in the Ab0479s00 table.
	 * 
	 *  ab0479s00
	 *            Ab0479s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0479s00>
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<EmpresaAuditora> findAll(EmpresaAuditora ab0479s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				EmpresaAuditoraDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0479s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<EmpresaAuditora>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0479s00 table using like.
	 * 
	 *  ab0479s00
	 *            Ab0479s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0479s00>
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<EmpresaAuditora> findAllLike(EmpresaAuditora ab0479s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EmpresaAuditoraDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0479s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<EmpresaAuditora>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0479s00 table.
	 * 
	 *  ab0479s00
	 *            Ab0479s00
	 *  Long
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(EmpresaAuditora ab0479s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0479S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0479s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0479s00 table using like.
	 * 
	 *  ab0479s00
	 *            Ab0479s00
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(EmpresaAuditora ab0479s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0479S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0479s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0479s00 selected for rup_table.
	 * 
	 *  ab0479s00            Ab0479s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0479s00>>
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<EmpresaAuditora>> reorderSelection(
			EmpresaAuditora ab0479s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EmpresaAuditoraDaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0479s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, EmpresaAuditora.class,
				filterParamList,
				"CODEMPAUD_079,DESEMPAUD_EU_079,DESEMPAUD_ES_079,FECBAJ_079");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<EmpresaAuditora>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            Ab0479s00
	 *  searchParams            Ab0479s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0479s00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<EmpresaAuditora>> search(
			EmpresaAuditora filterParams, EmpresaAuditora searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EmpresaAuditoraDaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, EmpresaAuditora.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"CODEMPAUD_079,DESEMPAUD_EU_079,DESEMPAUD_ES_079,FECBAJ_079");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<EmpresaAuditora>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filterab0479s00            Ab0479s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filterab0479s00 the filterab 0479 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override()
	public void removeMultiple(EmpresaAuditora filterab0479s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EmpresaAuditoraDaoImpl.QUERY_SELECT);

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab0479s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings(value = "unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						EmpresaAuditora.class, query, params,
						"CODEMPAUD_079,DESEMPAUD_EU_079,DESEMPAUD_ES_079,FECBAJ_079");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0479s00 entity.
	 * 
	 *  ab0479s00            Ab0479s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(EmpresaAuditora ab0479s00) {

		StringBuilder where = new StringBuilder(
				EmpresaAuditoraDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0479s00 != null && ab0479s00.getCodempaud079() != null) {
			where.append(" AND t1.CODEMPAUD_079 = ?");
			params.add(ab0479s00.getCodempaud079());
		}
		if (ab0479s00 != null && ab0479s00.getDesempaudEu079() != null) {
			where.append(" AND t1.DESEMPAUD_EU_079 = ?");
			params.add(ab0479s00.getDesempaudEu079());
		}
		if (ab0479s00 != null && ab0479s00.getDesempaudEs079() != null) {
			where.append(" AND t1.DESEMPAUD_ES_079 = ?");
			params.add(ab0479s00.getDesempaudEs079());
		}
		if (ab0479s00 != null && ab0479s00.getFecbajaDesde() != null) {
			where.append(" AND t1.FECBAJ_079 >= ?");
			params.add(ab0479s00.getFecbajaDesde());
		}
		if (ab0479s00 != null && ab0479s00.getFecbajaHasta() != null) {
			where.append(" AND t1.FECBAJ_079 <= ?");
			params.add(ab0479s00.getFecbajaHasta());
		}
		
		//where.append(" AND (t1.FECBAJ_079 IS NULL OR t1.FECBAJ_079 > SYSDATE)");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0479s00 entity.
	 * 
	 *  ab0479s00            Ab0479s00 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(EmpresaAuditora ab0479s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				EmpresaAuditoraDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0479s00 != null && ab0479s00.getCodempaud079() != null) {
			where.append(" AND UPPER(t1.CODEMPAUD_079) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0479s00.getCodempaud079().toUpperCase() + "%");
			} else {
				params.add("%" + ab0479s00.getCodempaud079().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CODEMPAUD_079 IS NOT NULL");
		}
		if (ab0479s00 != null && ab0479s00.getDesempaudEu079() != null) {
			where.append(" AND UPPER(t1.DESEMPAUD_EU_079) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0479s00.getDesempaudEu079().toUpperCase() + "%");
			} else {
				params.add("%" + ab0479s00.getDesempaudEu079().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESEMPAUD_EU_079 IS NOT NULL");
		}
		if (ab0479s00 != null && ab0479s00.getDesempaudEs079() != null) {
			where.append(" AND UPPER(t1.DESEMPAUD_ES_079) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0479s00.getDesempaudEs079().toUpperCase() + "%");
			} else {
				params.add("%" + ab0479s00.getDesempaudEs079().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESEMPAUD_ES_079 IS NOT NULL");
		}
		if (ab0479s00 != null && ab0479s00.getFecbajaDesde() != null) {
			where.append(" AND t1.FECBAJ_079 >= ?");
			params.add(ab0479s00.getFecbajaDesde());
		}
		if (ab0479s00 != null && ab0479s00.getFecbajaHasta() != null) {
			where.append(" AND t1.FECBAJ_079 <= ?");
			params.add(ab0479s00.getFecbajaHasta());
		}
		if(ab0479s00 != null && ab0479s00.getFecbajaDesde() == null && ab0479s00.getFecbajaHasta() == null){
			where.append(" AND (t1.FECBAJ_079 IS NULL OR t1.FECBAJ_079 > SYSDATE)");
		}
		//where.append(" AND (t1.FECBAJ_079 IS NULL OR t1.FECBAJ_079 > SYSDATE)");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
